//
//  AppDelegate.swift
//  Do It
//
//  Created by Jim Dovey on 8/23/19.
//  Copyright © 2019 Jim Dovey. All rights reserved.
//

import UIKit
import CoreData
import os

@UIApplicationMain
class AppDelegate: UIResponder, UIApplicationDelegate {



    func application(_ application: UIApplication, didFinishLaunchingWithOptions launchOptions: [UIApplication.LaunchOptionsKey: Any]?) -> Bool {
        // Override point for customization after application launch.
        return true
    }

    // MARK: UISceneSession Lifecycle

    func application(_ application: UIApplication, configurationForConnecting connectingSceneSession: UISceneSession, options: UIScene.ConnectionOptions) -> UISceneConfiguration {
        // Called when a new scene session is being created.
        // Use this method to select a configuration to create the new scene with.
        return UISceneConfiguration(name: "Default Configuration", sessionRole: connectingSceneSession.role)
    }

    func application(_ application: UIApplication, didDiscardSceneSessions sceneSessions: Set<UISceneSession>) {
        // Called when the user discards a scene session.
        // If any sessions were discarded while the application was not running, this will be called shortly after application:didFinishLaunchingWithOptions.
        // Use this method to release any resources that were specific to the discarded scenes, as they will not return.
    }

    // MARK: - Core Data stack
    
    lazy var persistentContainer: NSPersistentContainer = {
        let container = NSPersistentContainer(name: "TodoItems")
        container.loadPersistentStores { storeDescription, error in
            if let error = error as NSError? {
                showErrorDialog(
                    for: error,
                    title: NSLocalizedString("Error loading data", comment: "Alert title")
                )
            }
        }
        
        // install the default items (if necessary) in the background
        let context = container.newBackgroundContext()
        context.perform {
            let request: NSFetchRequest<TodoItemList> = TodoItemList.fetchRequest()
            let count = try? context.count(for: request)
            guard (count ?? 0) == 0 else {
                // we have a pre-populated store
                return
            }
            
            do {
                try importSampleData(to: context)
            }
            catch let error as NSError {
                showErrorDialog(
                    for: error,
                    title: NSLocalizedString("Error importing sample data", comment: "Alert title"))
            }
            catch {
                preconditionFailure("Failed to import sample data: \(error)")
            }
        }
        
        return container
    }()
    
    func saveContext() {
        let context = persistentContainer.viewContext
        context.performAndWait {
            if context.hasChanges {
                do {
                    try context.save()
                }
                catch let error as NSError {
                    showErrorDialog(
                        for: error,
                        title: NSLocalizedString("Error saving data", comment: "Alert title"))
                }
                catch {
                    preconditionFailure("Non-cocoa error saving data: \(error)")
                }
            }
        }
    }
}

// MARK: - Convenience

extension UIApplication {
    var appDelegate: AppDelegate { delegate as! AppDelegate }
    var persistentContainer: NSPersistentContainer { appDelegate.persistentContainer }
    func saveContext() { appDelegate.saveContext() }
}

func showErrorDialog(for error: NSError, title: String) {
    // first: always log the error details
    os_log(.error, "%{public}@: %{public}@", title, error)

    #if DEBUG
    let alert = UIAlertController(
        title: title,
        message: error.localizedRecoverySuggestion
            ?? error.localizedFailureReason
            ?? error.localizedDescription,
        preferredStyle: .alert)
    
    if let windowScene = UIApplication.shared.connectedScenes.first(where: { $0 is UIWindowScene }) as? UIWindowScene {
        windowScene.windows.first!.rootViewController?.present(alert, animated: true)
    }
    #endif
}

